package org.msh.etbm.rest.export;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.etbm.commons.apidoc.annotations.ApiDoc;
import org.msh.etbm.commons.apidoc.annotations.ApiDocMethod;
import org.msh.etbm.rest.commons.StandardResult;
import org.msh.tb.export_rest.core.ExcelExportAsyncService;
import org.msh.tb.export_rest.core.ExcelExportStatusResponse;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.File;

/**
 * API to support the follow-up and download of an exporting task to Excel
 * Created by rmemoria on 15/7/17.
 */
@ApiDoc(summary = "API para acompanhamento e download de exportação para Excel", group = "Reports")
@Name("excelExportREST")
@Path("/export")
public class ExcelExportREST {

    @In
    ExcelExportAsyncService excelExportAsyncService;


    @Path("/status/{taskId}")
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @ApiDocMethod(summary = "Retorna o status da exportação para Excel")
    public ExcelExportStatusResponse getStatus(@PathParam("taskId") String taskId) {
        return excelExportAsyncService.getStatus(taskId);
    }


    @Path("/download/{taskId}")
    @Produces("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")
    @GET
    @ApiDocMethod(summary = "Realiza o download do arquivo Excel gerado")
    public Response downloadFile(@PathParam("taskId") String taskId) {
        File excelFile = excelExportAsyncService.getDownloadFile(taskId);
        // file was found ?
        if (excelFile == null || !excelFile.exists()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }

        Response.ResponseBuilder response = Response.ok(excelFile);
        response.header("Content-Disposition", "attachment; filename=\"casos.xlsx\"");
        return response.build();
    }

    @Path("/cancel/{taskId}")
    @POST
    @Produces(MediaType.APPLICATION_JSON)
    @ApiDocMethod(summary = "Cancela a execução da exportação em andamento")
    public StandardResult cancelExport(@PathParam("taskId") String taskId) {
        excelExportAsyncService.cancelExport(taskId);
        return StandardResult.success(null);
    }
}
